package gov.va.med.mhv.rxrefill.converter;

import gov.va.med.mhv.rxrefill.data.model.RxTracking;
import gov.va.med.mhv.rxrefill.dto.RxTrackingDTO;

import java.io.Serializable;
import org.springframework.stereotype.Component;

@Component
public class RxTrackingConverter implements Serializable {

	private static final long serialVersionUID = -5996243023378509139L;

	public RxTrackingDTO convertDomainRxTracking(RxTracking rxTracking) {
		RxTrackingDTO rxTrackingDto = new RxTrackingDTO();
		rxTrackingDto.setId(rxTracking.getId());
		rxTrackingDto.setOplock(rxTracking.getOplock());
		rxTrackingDto.setStationNumber(rxTracking.getStationNumber());
		rxTrackingDto.setRxNumber(rxTracking.getRxNumber());
		rxTrackingDto.setCarrier(rxTracking.getCarrier());
		rxTrackingDto.setTrackingNumber(rxTracking.getTrackingNumber());
		rxTrackingDto.setCompleteDateTime(rxTracking.getCompleteDateTime());
		rxTrackingDto.setDivisionPhone(rxTracking.getDivisionPhone());
		rxTrackingDto.setNdc(rxTracking.getNdc());
		rxTrackingDto.setDateLoaded(rxTrackingDto.getDateLoaded());
		
		return rxTrackingDto;
	}

}
